% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{gmm_test}
\alias{gmm_test}
\title{GMM Orthogonality Test}
\usage{
gmm_test(x, lags = 1, skewness = 0, kurtosis = 3, ...)
}
\arguments{
\item{x}{a series representing the standardized residuals of some estimated model.}

\item{lags}{the lags for the co-moment test.}

\item{skewness}{the skewness of the estimated model residuals.}

\item{kurtosis}{the kurtosis of the estimated model residuals.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tstest.gmm} which has a print and
as_flextable method.
}
\description{
The GMM orthogonality test of Hansen (1982).
}
\details{
For parametric models estimated with a particular distribution, the
skewness and kurtosis should flow from the distributional model. See for example
\code{\link[tsdistributions]{dskewness}} and
\code{\link[tsdistributions]{dkurtosis}}.
}
\examples{
library(tsgarch)
library(tsdistributions)
library(data.table)
library(xts)
data("spy")
spyr <- na.omit(diff(log(spy)))
spec <- garch_modelspec(spyr, model = "egarch", order = c(2,1), constant = TRUE,
distribution = "jsu")
mod <- estimate(spec)
skewness <- dskewness("jsu", skew = coef(mod)["skew"], shape = coef(mod)["shape"])
# kurtosis is dkurtosis is the excess over the Normal (3) so we add back 3
# since the test takes the actual not excess kurtosis.
kurtosis <- dkurtosis("jsu", skew = coef(mod)["skew"], shape = coef(mod)["shape"]) + 3
test <- gmm_test(residuals(mod, standardize = TRUE), lags = 2, skewness = skewness,
kurtosis = kurtosis)
print(test, collapse = TRUE, include.decision = TRUE)

}
\references{
\insertRef{Hansen1982}{tstests}
}
