% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdts_predict.R
\name{sdts.predict}
\alias{sdts.predict}
\title{Scalable Dictionary learning for Time Series (SDTS) prediction function.}
\usage{
sdts.predict(model, data, window.size)
}
\arguments{
\item{model}{a model created by SDTS training function \code{\link[=sdts.train]{sdts.train()}}.}

\item{data}{a \code{vector} of \code{numeric}. Time series.}

\item{window.size}{an \code{int}. The average sliding window size.}
}
\value{
Returns a \code{vector} of \code{logical} with predicted annotations.
}
\description{
Scalable Dictionary learning for Time Series (SDTS) prediction function.
}
\examples{
# This is a fast toy example and results are useless. For a complete result, run the code inside
#'Not run' section below.
w <- c(110, 220)
subs <- 11000:20000
tr_data <- test_data$train$data[subs]
tr_label <- test_data$train$label[subs]
te_data <- test_data$test$data[subs]
te_label <- test_data$test$label[subs]
model <- sdts.train(tr_data, tr_label, w, verbose = 0)
predict <- sdts.predict(model, te_data, round(mean(w)))
sdts.f.score(te_label, predict, 1)
\dontrun{
windows <- c(110, 220, 330)
model <- sdts.train(test_data$train$data, test_data$train$label, windows, verbose = 0)
predict <- sdts.predict(model, test_data$test$data, round(mean(windows)))
sdts.f.score(test_data$test$label, predict, 1)
}
}
\seealso{
Other SDTS: \code{\link{sdts.f.score}},
  \code{\link{sdts.train}}
}
\concept{SDTS}
