% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass.R
\name{mass}
\alias{mass}
\title{Calculates the distance profile using MASS algorithm}
\usage{
mass(data.fft, query.window, data.size, window.size, data.mean, data.sd,
  query.mean, query.sd)
}
\arguments{
\item{data.fft}{precomputed data product.}

\item{query.window}{a \code{vector} of \code{numeric}. Query window.}

\item{data.size}{an \code{int}. The length of the reference data.}

\item{window.size}{an \code{int}. Sliding window size.}

\item{data.mean}{precomputed data moving average.}

\item{data.sd}{precomputed data moving standard deviation.}

\item{query.mean}{precomputed query average.}

\item{query.sd}{precomputed query standard deviation.}
}
\value{
Returns the \code{distance.profile} for the given query and the \code{last.product} for STOMP algorithm.
}
\description{
Mueen's Algorithm for Similarity Search is The Fastest Similarity Search Algorithm for Time Series Subsequences under Euclidean Distance and Correlation Coefficient.
}
\examples{
w <- toy_data$sub.len
ref.data <- toy_data$data[,1]
query.data <- toy_data$data[,1]
d.size <- length(ref.data)
q.size <- length(query.data)

pre <- mass.pre(ref.data, d.size, query.data, q.size, w)

dp <- list()
for(i in 1:(d.size - w + 1)) {
  dp[[i]] <- mass(pre$data.fft, query.data[i:(i-1+w)], d.size, w, pre$data.mean, pre$data.sd,
          pre$query.mean[i], pre$query.sd[i])
}
}
\references{
Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan, Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time Series Subsequences under Euclidean Distance

\url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass.pre]{mass.pre()}} to precomputation of input values.
}
