% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{simulate.tsgarch.spec}
\alias{simulate.tsgarch.spec}
\alias{simulate}
\title{Model Simulation}
\usage{
\method{simulate}{tsgarch.spec}(
  object,
  nsim = 1,
  seed = NULL,
  h = 1000,
  var_init = NULL,
  innov = NULL,
  innov_init = NULL,
  vreg = NULL,
  burn = 0,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsgarch.spec}.}

\item{nsim}{the number of sample paths to generate.}

\item{seed}{an integer that will be used in a call to set.seed before simulating.}

\item{h}{the number of time steps to simulate paths for.}

\item{var_init}{the seed value for initializing the variance equation recursion.
If NULL, the variance target value is used based on the supplied parameters.
This should be a vector and assumes all sample paths are seeded the same way.}

\item{innov}{an optional matrix of dimensions nsim by h of zero mean unit variance
(standardized) innovations which will be used instead of the model distribution
for simulation. No checks are performed on whether the supplied values are
standardized.}

\item{innov_init}{an optional vector of initialization values for the
standardized innovations. This allows the seeding of the initial innovations
with user supplied values (useful when simulating forward from an existing
model for the purpose of continuing the modeled series from some fixed point).}

\item{vreg}{an optional vector of length h representing any pre-multiplied
variance regressors to use in the simulation.}

\item{burn}{burn in. Will be discarded before returning the output.}

\item{...}{for aparch, fgarch, egarch and gjrgarch models, an optional
vector of length max(q,p) with values for initializing the ARCH equation and
named \dQuote{arch_initial}. This is mostly used for validation purposes. The
\dQuote{arch_initial} value is always returned by an estimated object.}
}
\value{
An object of class \dQuote{tsgarch.simulate} with slots for the
simulated sigma and series simulated distributions which are each of class
\dQuote{tsmodel.distribution}. The simulated error (not returned) is equal to
the simulated series less the mean equation constant if not equal to zero.
}
\description{
Simulates paths of a GARCH model.
}
\details{
Once a GARCH model is specified via \code{\link{garch_modelspec}},
the slot \dQuote{parmatrix} contains initial values for the parameters
which can be used to set them to any value for the simulation. This matrix
as well as details of the model (type, order, distribution) are the only
pieces of information used in the simulation. The \dQuote{vreg} argument in
the spec will be ignored. Instead, the user can supply a pre-multiplied vector
to the simulate function which will be used. Note that the \dQuote{multiplicative}
argument in the specification will be used in this case to determine how the
regressors enter the conditional variance equation. While the \dQuote{innov}
argument must be a matrix, all other values are vectors and assume that they
will be the same across all sample paths. If the user wants to assign different values
for arguments \dQuote{var_init}, \dQuote{innov_init} and \dQuote{vreg}, then
the simulate method should be called multiple times.
}
