% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss_to_net.R
\name{net_enn}
\alias{net_enn}
\title{Construct an epsilon-network from a distance matrix.}
\usage{
net_enn(
  D,
  eps,
  treat_NA_as = 1,
  is_dist_symetric = TRUE,
  weighted = FALSE,
  invert_dist_as_weight = TRUE,
  add_col_rownames = TRUE
)
}
\arguments{
\item{D}{Distance matrix}

\item{eps}{the threshold value to be considered a link. Only values lower
or equal to epsilon become 1.}

\item{treat_NA_as}{A numeric value, usually 1, that represent NA values in the
distance matrix}

\item{is_dist_symetric}{Boolean, TRUE (default) if dist is symmetric}

\item{weighted}{Boolean, TRUE will create a weighted network}

\item{invert_dist_as_weight}{Boolean, if weighted == TRUE, then the weights
become 1 - distance. This is the default behavior since most network
measures interpret higher weights as stronger connection.}

\item{add_col_rownames}{Boolean. If TRUE (default), it uses the column and row
names from dist matrix as node labels.}
}
\value{
a igraph network
}
\description{
Construct an epsilon-network from a distance matrix.
}
