% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last_tryCatchLog_result.R
\name{last.tryCatchLog.result}
\alias{last.tryCatchLog.result}
\title{Gets the logging result of the last call to \code{tryCatchLog} or \code{tryLog}}
\usage{
last.tryCatchLog.result()
}
\value{
the logging result of the last call to \code{\link{tryCatchLog}} or \code{\link{tryLog}}
        as \code{\link{data.frame}} comprised of one row per logged condition with these columns:
        \enumerate{
        \item{timestamp   - creation date and time of the logging entry}
        \item{severity    - the serverity level of the log entry (ERROR, WARN, INFO etc.)}
        \item{msg.text    - the message text of the log entry}
        \item{compact.stack.trace - the short stack trace containing only entries with source code
                                    references down to line of code that has thrown the condition}
        \item{full.stack.trace    - the full stack trace with all calls down to the line of code that
                                    has thrown the condition (including calls to R internal functions
                                    and other functions even when the source code in not available).}
        \item{dump.file.name      - name of the created dump file (if any)}
        }

        If no condition is logged at all an empty \code{data.table} is returned.
}
\description{
The last logging result after calling \code{tryCatchLog} or \code{tryLog} can be retrieved by
calling this function.
}
\details{
The typical use case is to get and store the log output not only in a log file but
also in another place that is not supported by \code{futile.logger}, e. g. in
a data base table of your application or displaying it in a GUI (user interface).

Another use case is to review the last log output on the console during debugging.
}
\examples{
last.tryCatchLog.result()

}
\seealso{
\code{\link{tryCatchLog}},
         \code{\link{tryLog}}
}
