% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{splineDesigncpp}
\alias{splineDesigncpp}
\title{B-Spline Design Matrix}
\usage{
splineDesigncpp(
  knots = NA_real_,
  x = NA_real_,
  ord = 4L,
  derivs = as.integer(c(0))
)
}
\arguments{
\item{knots}{A numeric vector specifying the positions of the knots,
including both boundary and internal knots.}

\item{x}{A numeric vector of values where the B-spline functions
or their derivatives will be evaluated. The values of \code{x}
must lie within the range of the "inner" knots, i.e., between
\code{knots[ord]} and \code{knots[length(knots) - (ord - 1)]}.}

\item{ord}{A positive integer indicating the order of the B-spline.
This corresponds to the number of coefficients in each piecewise
polynomial segment, where \code{ord = degree + 1}.}

\item{derivs}{An integer vector specifying the order of derivatives
to be evaluated at the corresponding \code{x} values. Each value
must be between \code{0} and \code{ord - 1}, and the vector is
conceptually recycled to match the length of \code{x}.
The default is \code{0}, meaning the B-spline functions themselves
are evaluated.}
}
\value{
A matrix with dimensions
\code{c(length(x), length(knots) - ord)}. Each row corresponds
to a value in \code{x} and contains the coefficients of the
B-splines, or the specified derivatives, as defined by the
\code{knots} and evaluated at that particular value of \code{x}.
The total number of B-splines is \code{length(knots) - ord},
with each B-spline defined by a set of \code{ord} consecutive knots.
}
\description{
Computes the design matrix for B-splines based on the
specified \code{knots} and evaluated at the values in \code{x}.
}
\examples{

splineDesigncpp(knots = 1:10, x = 4:7)
splineDesigncpp(knots = 1:10, x = 4:7, derivs = 1)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
