% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aberrantscoreslong.R
\name{aberrantscoreslong}
\alias{aberrantscoreslong}
\title{Convert outcome to aberrant ranks}
\usage{
aberrantscoreslong(y, cutoff, cutoff_dir = "less", tau = 0, z = NULL)
}
\arguments{
\item{y}{Vector of outcomes. Length is equal to the number of units}

\item{cutoff}{The cutoff for whether an outcome is aberrant. Any outcome more extreme
then this cutoff will be considered aberrant}

\item{cutoff_dir}{Either `less` or `greater`, indicating whether outcomes should be
aberrant if they are less than the `cutoff` or greater than the `cutoff`, respectively}

\item{tau}{The null treatment effect to be subtracted from all treated units
before aberrant ranking commences. If `tau != 0`, then `z` is required}

\item{z}{Vector with length equal to that of y. Each element specifies whether a unit is treated (1) or not (0)}
}
\value{
Vector of aberrant ranks corresponding to `y`
}
\description{
Replaces non-aberrant responses by 0 and ranks the aberrant responses by severity.
The more aberrant responses have the highest ranks.
}
\details{
This function serves the same function as [aberrantscores()] but takes inputs in
the `long` format instead of the `wide` format (see [formattrip()] for a
description of the two formats, their uses, and their creation).

This can be useful for creating a column of `sc` in [infsentrip()] if the
aberrant rank test is desired for that variable.
}
\examples{
# Generate some data
set.seed(316)
n <- 30
x <- rnorm(n, 0, 1)
nt <- floor(n * 0.2)
nc <- n - nt
z <- c(rep(1, nt), rep(0, nc))
# Create a distance matrix (all units in one stratum here)
dist <- dist_mahal(data.frame(x = x), z, rep(1, n))[[1]]
# Conduct the triples match
triplesm <- triples_st(cost = dist, z = z, solver = "rlemon")
# Create primary and negative outcomes with some random unit names
y <- cbind(rnorm(40), runif(40))
rownames(y) <- sample(1:40)
# Reformat the triples match
ylong <- formattrip(m = triplesm, y = y, type = "long")
# Aberrant ranks for primary outcome
y[, 1] <- aberrantscoreslong(y[, 1], cutoff = 0.5, cutoff_dir = "greater")
}
\seealso{
aberrantscores for the same function with inputs in the wide format instead of long

formattrip for formatting of the triples match into wide or long format
}
