% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readArgos}
\alias{readArgos}
\alias{readDiag}
\title{Read Argos "DAT" or "DIAG" files}
\usage{
readArgos(
  x,
  correct.all = TRUE,
  dtFormat = "\%Y-\%m-\%d \%H:\%M:\%S",
  tz = "GMT",
  duplicateTimes.eps = 0.01,
  p4 = "+proj=longlat +ellps=WGS84",
  verbose = FALSE,
  read_alt = NULL,
  ...
)

readDiag(x, return_trip = FALSE, read_alt = 1L, ...)
}
\arguments{
\item{x}{vector of file names of Argos "DAT" or "DIAG" files.}

\item{correct.all}{logical - enforce validity of data as much as possible?
(see Details)}

\item{dtFormat}{the DateTime format used by the Argos data "date" and "time"
pasted together}

\item{tz}{timezone - GMT/UTC is assumed}

\item{duplicateTimes.eps}{what is the tolerance for times being duplicate?}

\item{p4}{PROJ.4 projection string, "+proj=longlat +ellps=WGS84" is assumed}

\item{verbose}{if TRUE, details on date-time adjustment is reported}

\item{read_alt}{is \code{NULL} by default, with longitude and latitude read from the PRV message, if \code{1} or \code{2}
then attempt is made to read the alternative locations (but these are not always present)}

\item{...}{reserved for future use}

\item{return_trip}{for \code{\link[=readDiag]{readDiag()}} if \code{TRUE} will return a trip object, use \code{read_alt} to control the location}
}
\value{
\code{readArgos} returns a \code{trip} object, if all goes well, or simply a
\code{\link[sp]{SpatialPointsDataFrame-class}}.

\code{readDiag} returns a \code{data.frame} with 8 columns:
\itemize{
\item {\code{lon1},\code{lat1} first pair of coordinates}
\item {\code{lon1},\code{lat1} second pair of coordinates}
\item {gmt DateTimes as POSIXct}
\item {id Platform Transmitting Terminal (PTT) ID}
\item {lq Argos location quality class}
\item {iq some other thing}
}
}
\description{
Return a (Spatial) data frame of location records from raw Argos files.
Multiple files may be read, and each set of records is appended to the data
frame in turn.  Basic validation of the data is enforced by default.
}
\details{
\code{readArgos} performs basic validation checks for class \code{trip} are
made, and enforced based on \code{correct.all}:

No duplicate records in the data, these are simply removed.  Records are
ordered by DateTime ("date", "time", "gmt") within ID ("ptt").  No duplicate
DateTime values within ID are allowed: to enforce this the time values are
moved forward by one second - this is done recursively and is not robust.

If validation fails the function will return a
\code{\link[sp]{SpatialPointsDataFrame-class}}.  Files that are not obviously of
the required format are skipped.

Argos location quality data "class" are ordered, assuming that the available
levels is \code{levels=c("Z", "B", "A", "0", "1", "2", "3")}.

A projection string is added to the data, assuming the PROJ.4 longlat - if
any longitudes are greater than 360 the PROJ.4 argument "+over" is added.

\code{readDiag} simply builds a \code{data.frame}.

With \code{read_alt} the default value \code{NULL} returns the PRV location as-is. Some files may have
a standardized location, and a dummy. If \code{read_alt} is set to 1 or 2 the corresponding "alternative"
location is returned. 1 is a standardized location corresponding to the original PRV message, and 2 is a
"dummy" location.
}
\section{Warning }{


This works on some Argos files I have seen.
}

\examples{
argosfile <-
  system.file("extdata/argos/98feb.dat", package = "trip", mustWork = TRUE)
argos <- readArgos(argosfile)
}
\references{
The Argos data documentation was (ca. 2003) at
http://www.argos-system.org/manual.  Specific details on the PRV
("provide data") format were found in Chapter 4_4_8, originally at
'http://www.cls.fr/manuel/html/chap4/chap4_4_8.htm'.
}
\seealso{
\code{\link{trip}}, \code{\link[sp]{SpatialPointsDataFrame-class}},
\code{\link{adjust.duplicateTimes}}, for manipulating these data, and
\code{\link{argos.sigma}} for relating a numeric value to Argos quality
"classes".

\code{\link{sepIdGaps}} for splitting the IDs in these data on some minimum
gap.

\code{\link{order}}, \code{\link{duplicated}}, , \code{\link{ordered}} for
general manipulation of this type.
}
\keyword{IO}
\keyword{manip}
