% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stick_to.R
\name{stick_to}
\alias{stick_to}
\alias{stick_to_}
\alias{unstick}
\title{Work on a specific attribute within a pipeline}
\usage{
stick_to(obj, at)

stick_to_(obj, at)

unstick(x)
}
\arguments{
\item{obj}{An object with an \code{at} attribute.}

\item{at}{The name of the attribute to be considered.}

\item{x}{An object to be unsticked. 
Must have \code{".obj_stick"} and \code{".at_stick"} attributes.}
}
\value{
\code{stick_to} basically inverses the roles of \code{.data} and \code{at}, 
meaning that \code{.data} becomes an attribute of the selected attribute. 
\code{unstick} makes the inverse operation.
}
\description{
The functions \code{stick_to} and \code{unstick} enable 
to select an attribute within a pipe and work on it. 

It must be combined with the \code{\%@>\%} pipe to work properly, 
see the example below.
}
\examples{
\dontrun{
library(dplyr)
library(observer)

df <- ggplot2::diamonds %>% 
  mutate(depth2 = 100*2*z/(x+y)) %>% 
  observe_if(abs(depth-depth2) < 1)

observations(df)

df %>% 
  stick_to(observations) %@>% 
  mutate(Id = 2) %@>% 
  select(Id, Status) %>% 
  unstick()

observations(df)
}

}
