% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{map_cog}
\alias{map_cog}
\title{Apply a function to each element of a vector and return a vector of cognostics data frames}
\usage{
map_cog(.x, .f, ...)
}
\arguments{
\item{.x}{a list or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{.f}{a function, formula, or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{...}{additional arguments passed on to .f (see \code{\link[purrr]{map}} for details)}
}
\description{
Apply a function to each element of a vector and return a vector of cognostics data frames
}
\details{
See \code{\link[purrr]{map}}
}
\examples{
\donttest{
library(dplyr)
library(tidyr)
library(plotly)
ggplot2::mpg \%>\%
  nest(data = !one_of(c("manufacturer", "class"))) \%>\%
  mutate(
    cog = map_cog(data, function(x) tibble(mean_hwy = mean(x$hwy))),
    panel = map_plot(data, function(x) {
      plot_ly(data = x, x = ~cty, y = ~hwy,
        type = "scatter", mode = "markers")
    })
  ) \%>\%
  trelliscope(name = "city_vs_highway_mpg")
}
}
