% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognostics.R
\name{cogDisplayHref}
\alias{cogDisplayHref}
\title{DisplayHref Cognostic}
\usage{
cogDisplayHref(state, label = "link", desc = "display link",
  group = "common", target = "_blank", defLabel = FALSE,
  defActive = FALSE, filterable = FALSE, sortable = TRUE, log = FALSE)
}
\arguments{
\item{state}{the state of the display to link to, using \code{\link{stateSpec}} - at a minimum the name and group of the display must be specivied - additionally, default parameter settings (such as layout, sorting, filtering, etc.) can be set to be in effect when the display is launched (see \code{\link{stateSpec}} for details)}

\item{label}{label of the href}

\item{desc, group, defLabel, defActive, filterable, sortable, log}{arguments passed to \code{\link{cog}}}

\item{target}{value to be used for the \code{target} attribute of the \code{a} html tag - default is "_blank" which will open the link in a new window}
}
\value{
a hash string
}
\description{
Create href that points to another trelliscope display with optional state
}
\examples{
\dontrun{
library(ggplot2)

vdbConn(tempfile(), autoYes = TRUE)

# divide housing data by county
byCounty <- divide(housingData::housing, by = c("county", "state"))

xlim <- as.Date(c("2008-01-31", "2016-01-31"))

# plot list price vs. time for each county
makeDisplay(byCounty, name = "county_time",
  panelFn = function(x)
    ggplot(x, aes(time, medListPriceSqft)) +
      geom_point() + xlim(xlim))

# divide housing data by state
byState <- divide(housingData::housing, by = "state")

# create a "displayHref" cognostic that links to the by county display
# filtered down to all counties in the current state
cogFn <- function(x) {
  state <- stateSpec(
    name = "county_time",
    sort = list(county = "asc"),
    layout = list(nrow = 2, ncol = 4),
    filter = list(state = list(select = getSplitVar(x, "state"))))

  list(countyPlots = cogDisplayHref(state = state, defLabel = TRUE))
}

# plot distribution of list price vs. time for each state
makeDisplay(byState, name = "state_time_CI",
  panelFn = function(x)
    ggplot(x, aes(time, medListPriceSqft)) +
      stat_summary(fun.data = "mean_cl_boot") + xlim(xlim),
  cogFn = cogFn)

# open up the state display
# try clicking on the link for "countyPlots"
# the by county display will be loaded filtered to the state
view("state_time_CI")
}

}
\seealso{
\code{\link{validateState}}, \code{\link{cogHref}}
}
