% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTreeDiff.R
\name{tipDiff}
\alias{tipDiff}
\title{Find tip position differences}
\usage{
tipDiff(tr1, tr2, vec1 = NULL, vec2 = NULL, sizeOfDifferences = FALSE)
}
\arguments{
\item{tr1}{an object of the class \code{phylo}: the first tree to compare.}

\item{tr2}{an object of the class \code{phylo}: the second tree to compare.}

\item{vec1}{an optional input, the result of \code{treeVec(tr1, lambda=0)}, to speed up the computation.}

\item{vec2}{an optional input, the result of \code{treeVec(tr2, lambda=0)}, to speed up the computation.}

\item{sizeOfDifferences}{a logical (default FALSE) specifying whether the size of the differences in the vectors per tip is also computed}
}
\value{
A data frame of the tree tips and the number of ancestral differences between them in the two trees, in order of increasing difference.
A tip is said to have zero difference if each of its ancestral nodes admits the same tip partition in the two trees.
}
\description{
Find the topologicial differences between two trees with the same tip labels. The function returns a data frame of the tips and the number of differences in their ancestry between the two trees.
Called by \code{\link{plotTreeDiff}}, which highlights the differing tips in a plot of the two trees.
}
\examples{
## simple example on trees with five tips:
tr1 <- read.tree(text="((A:1,B:1):1,((C:1,D:1):1,E:1):1):1;")
tr2 <- read.tree(text="((A:1,B:1):1,(C:1,(D:1,E:1):1):1):1;")
tipDiff(tr1,tr2)

## example on larger woodmice trees
data(woodmiceTrees)
tipDiff(woodmiceTrees[[1]],woodmiceTrees[[2]])

}
\seealso{
\code{\link{medTree}} \code{\link{plotTreeDiff}}
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
