% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query-accessors}
\alias{query-accessors}
\alias{query_pattern_count}
\alias{query_capture_count}
\alias{query_string_count}
\alias{query_start_byte_for_pattern}
\alias{query_end_byte_for_pattern}
\title{Query accessors}
\usage{
query_pattern_count(x)

query_capture_count(x)

query_string_count(x)

query_start_byte_for_pattern(x, i)

query_end_byte_for_pattern(x, i)
}
\arguments{
\item{x}{\verb{[tree_sitter_query]}

A query.}

\item{i}{\verb{[double(1)]}

The \code{i}th pattern to extract the byte for.}
}
\value{
\itemize{
\item \code{query_pattern_count()}, \code{query_capture_count()}, and
\code{query_string_count()} return a single double count value.
\item \code{query_start_byte_for_pattern()} and \code{query_end_byte_for_pattern()} return
a single double for their respective byte if there was an \code{i}th pattern,
otherwise they return \code{NA}.
}
}
\description{
\itemize{
\item \code{query_pattern_count()} returns the number of patterns in a query.
\item \code{query_capture_count()} returns the number of captures in a query.
\item \code{query_string_count()} returns the number of string literals in a query.
\item \code{query_start_byte_for_pattern()} and \code{query_end_byte_for_pattern()} return
the byte where the \code{i}th pattern starts/ends in the query \code{source}.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
source <- '(binary_operator
  lhs: (identifier) @lhs
  operator: _ @operator
  rhs: (function_definition) @rhs
  (#eq? @lhs "fn")
)'
language <- treesitter.r::language()

query <- query(language, source)

query_pattern_count(query)
query_capture_count(query)
query_string_count(query)

query_start_byte_for_pattern(query, 1)
query_end_byte_for_pattern(query, 1)

text <- "
  fn <- function() {}
  fn2 <- function() {}
  fn <- 5
  fn <- function(a, b, c) { a + b + c }
"
parser <- parser(language)
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

query_matches(query, node)
\dontshow{\}) # examplesIf}
}
