% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_symbol}
\alias{node_symbol}
\title{Node symbol}
\usage{
node_symbol(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single integer.
}
\description{
\code{node_symbol()} returns the symbol id of the current node as an integer.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Top level program node
node_symbol(node)

# The whole `<-` binary operator node
node <- node_child(node, 1)
node_symbol(node)

# Just the literal `<-` operator itself
node <- node_child_by_field_name(node, "operator")
node_symbol(node)
\dontshow{\}) # examplesIf}
}
