% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write-methods.R
\name{writeTrmn}
\alias{writeTrmn}
\title{Write a .trmn tree}
\usage{
writeTrmn(tree, file)
}
\arguments{
\item{tree}{TreeMan object or TreeMen object}

\item{file}{file path}
}
\description{
Write to disk a \code{TreeMan} or \code{TreeMan} object using the .trmn treefile
}
\details{
Write a tree(s) to file using the .trmn format.
It is faster to read and write tree files using treeman with the .trmn file format.
In addition it is possible to encode more information than possible with the
Newick, e.g. any taxonomic information and additional slot names added to 
the tree are recorded in the file.
}
\examples{
library(treeman)
tree <- randTree(10)
writeTrmn(tree, file='test.trmn')
tree <- readTrmn('test.trmn')
file.remove('test.trmn')
}
\seealso{
\code{\link{readTrmn}},
\code{\link{readTree}},\code{\link{writeTree}},
\code{\link{randTree}}, \code{\link{saveTreeMan}}, \code{\link{loadTreeMan}}
}
