% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nd-methods.R
\name{getNdAge}
\alias{getNdAge}
\title{Get age}
\usage{
getNdAge(tree, id, tree_age)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{node id}

\item{tree_age}{numeric value of known age of tree}
}
\description{
Return the age for \code{id}. Requires the known age of the tree to be provided.
}
\details{
Returns a numeric.
}
\examples{
library(treeman)
data(mammals)
# when did apes emerge?
# get parent id for all apes
prnt_id <- getPrnt(mammals, ids=c('Homo_sapiens', 'Hylobates_concolor'))
# mammal_age <- getAge(mammals)  # ~166.2, needs to be performed when tree is not up-to-date
getNdAge(mammals, id=prnt_id, tree_age=166.2)
}
\seealso{
\code{\link{getNdsAge}}, 
\code{\link{getSpnAge}}, 
\code{\link{getSpnsAge}}, 
\code{\link{getPrnt}}, \code{\link{getAge}}
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
