% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node-declaration.R
\docType{class}
\name{Node-class}
\alias{Node-class}
\alias{Node-method}
\alias{as.character,Node-method}
\alias{show,Node-method}
\alias{print,Node-method}
\alias{summary,Node-method}
\alias{[,Node,character,missing,missing-method}
\title{Node-class}
\usage{
\S4method{as.character}{Node}(x)

\S4method{show}{Node}(object)

\S4method{print}{Node}(x)

\S4method{summary}{Node}(object)

\S4method{[}{Node,character,missing,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{\code{Node} object}

\item{object}{\code{Node} object}

\item{i}{slot name}

\item{j}{missing}

\item{...}{missing}

\item{drop}{missing}
}
\description{
The \code{Node} is an S4 class used for displaying node information.
It is only generated when a user implements the \code{[[]]} on a tree. Information
is only accurate if tree has been updated with \code{updateTree()}.
}
\section{Slots}{

\describe{
\item{\code{id}}{unique ID for node in tree['ndlst']}

\item{\code{spn}}{length of preceding branch}

\item{\code{prid}}{parent node ID}

\item{\code{ptid}}{child node ID}

\item{\code{kids}}{descending tip IDs}

\item{\code{nkids}}{number of descending tip IDs}

\item{\code{txnym}}{list of associated taxonyms}

\item{\code{pd}}{total branch length represented by node}

\item{\code{prdst}}{total branch length of connected prids}

\item{\code{root}}{T/F root node?}

\item{\code{tip}}{T/F tip node?}
}}

\seealso{
\code{\link{TreeMan-class}}, \code{\link{TreeMen-class}}
}
