% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-spcl-methods.R
\name{getOtgrp}
\alias{getOtgrp}
\title{Get outgroup}
\usage{
getOtgrp(tree, ids)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}
}
\description{
Return the outgroup based on a tree and a vector of IDs.
}
\details{
Returns a id, character. If there are multiple possible outgroups, returns NULL.
}
\examples{
library(treeman)
data(mammals)
# orangutan is an outgroup wrt humans and chimps
getOtgrp(mammals, ids=c('Homo_sapiens', 'Pan_troglodytes', 'Pongo_pygmaeus'))
}
\seealso{
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
