% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsKids}
\alias{getNdsKids}
\title{Get children IDs for multiple nodes}
\usage{
getNdsKids(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return the node ids of all tips that descend from each node in \code{ids}.
}
\details{
Returns a list, parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsKids(tree, id=tree['nds'])
}
\seealso{
\code{\link{getNdKids}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
