% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write-methods.R
\name{readTrmn}
\alias{readTrmn}
\title{Read a .trmn tree}
\usage{
readTrmn(file, wndmtrx = FALSE, parallel = FALSE, progress = "none")
}
\arguments{
\item{file}{file path}

\item{wndmtrx}{T/F add node matrix? Default FALSE.}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return a \code{TreeMan} or \code{TreeMen} object from a .trmn treefile
}
\details{
Read a tree(s) from a file using the .trmn format.
It is faster to read and write tree files using treeman with the .trmn file format.
In addition it is possible to encode more information than possible with the
Newick, e.g. any taxonomic information and additional slot names added to 
the tree are recorded in the file.
}
\examples{
library(treeman)
tree <- randTree(10)
writeTrmn(tree, file='test.trmn')
tree <- readTrmn('test.trmn')
file.remove('test.trmn')
}
\seealso{
\code{\link{writeTrmn}},
\code{\link{readTree}},\code{\link{writeTree}},
\code{\link{randTree}}, \code{\link{saveTreeMan}}, \code{\link{loadTreeMan}}
}
