% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{pinTips}
\alias{pinTips}
\title{Pin tips to a tree}
\usage{
pinTips(tree, tids, lngs, ends, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tids}{new tip ids}

\item{lngs}{list of vectors of the lineages of each tid}

\item{ends}{end time points for each tid}

\item{...}{\code{plyr} arguments}
}
\description{
Returns a tree with new tips added based on given lineages and time points
}
\details{
User must provide a vector of new tip IDs, a list of the ranked lineages
for these IDs (in ascending order) and a vector of end time points for each new ID
(0s for extant tips). The function expects the given tree to be taxonomically informed;
the \code{txnym} slot for every node should have a taxonomic label. The function takes
the lineage and tries to randomly add the new tip at the lowest point in the taxonomic rank
before the end time point. Parallelizable.
}
\examples{
# see https://github.com/DomBennett/treeman/wiki/Pinning-tips for a detailed example
}
\seealso{
\url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}

