% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlm.R
\name{dlm}
\alias{dlm}
\title{Dendro-flavoured linear model}
\usage{
dlm(
  chrono,
  climate,
  selection,
  timespan = NULL,
  var_names = NULL,
  param_names = NULL,
  intercept = TRUE,
  scale = FALSE
)
}
\arguments{
\item{chrono}{\code{data.frame} containing a tree-ring
chronologies, e.g. as obtained by \code{chron} of package dplR.}

\item{climate}{either a \code{data.frame} or \code{matrix} with
climatic data in monthly resolution, with year, month and
climate parameters in columns (all columns except year and month
will be recognized as parameters for response or correlation
functions), or a single \code{data.frame} or \code{matrix} in
13-column format (see below), or a (potentially named) list of
one or several of the latter.}

\item{selection}{either a numeric vector, a modifier, or a chain
of modifiers specifying the parameter selection for the model
(see Details).}

\item{timespan}{\code{integer} vector of length 2 specifying the
time interval (in years) to be considered for analysis. Defaults
to the maximum possible interval.}

\item{var_names}{\code{character} vector with variable
names. Defaults to corresponding column names of parameter \code{climate} if
given as \code{data.frame}, or its names if given as \code{list}.}

\item{param_names}{\code{character} vector with parameter
names. Defaults to auto-generated (potentially compound) names.}

\item{intercept}{\code{logical}: should intercept be included in
model?}

\item{scale}{\code{logical}: should data be scaled prior to
computing model?  If \code{TRUE}, \code{intercept} will be set
to \code{FALSE}.}
}
\value{
'dlm' returns an 'object' of class '"tc_dlm"', which is a
  superclass of 'lm'. Additional elements to what is included in
  standard 'lm' objects:
  
  \item{call_dlm}{the call made to function 'dlm'}

  \item{design}{the design matrix on which this call to 'dlm'
  operates}
  
  \item{truncated}{the input data truncated to the common timespan
  or the specified timespan}
  
  \item{original}{the original input data, with the climate data
  being recast into a single data.frame}
}
\description{
This is a wrapper around \code{\link{lm}} for working with the
same data structures and modifiers as \code{\link{dcc}} does.
}
\details{
Input chronology data can be a \code{data.frame} such as produced
by function \code{chron} of package dplR. It has to be a
\code{data.frame} with at least one column containing the
tree-ring indices, and the corresponding years as \code{rownames}.
  
For climatic input data, there are three possibilities: Firstly,
input climatic data can be a \code{data.frame} or \code{matrix}
consisting of at least 3 rows for years, months and at least one
climate parameter in the given order. Secondly, input climatic
data can be a single \code{data.frame} or \code{matrix} in the
style of the original DENDROCLIM2002 input data, i.e. one
parameter with 12 months in one row, where the first column
represents the year. Or thirdly, input climatic data can be a
(potentially named) list of one or several of the latter described
\code{data.frame} or \code{matrices}. If named list is provided,
potentially provided variable names through argument
\code{var_names} are ignored. As an internal format dispatcher
checks the format automatically, it is absolutely necessary that
in all three cases, only complete years (months 1-12) are
provided. It is not possible to mix different formats in one go.
  
In 'dlm', there is no default parameter selection, in contrast to
'dcc'. Parameters can be selected with the 'selection' parameter
in two different ways:

\itemize{
\item simple selections: as an example -6:9 selects from all
  climate variables all months from previous year's June (-6,
  previous year's months are specified as negative integers) to
  current years September (9, months of the current year are
  specified as positive integers) as model parameters. Months from
  the previous year and the year before that can be selected using
  \link{treeclim-shifters} like \code{..(6)} to refer to July of
  the year before the previous year.

\item using \emph{modifiers}: More complex parameter selections
  can be obtained by the \emph{modifiers} provided in treeclim:
  \code{.range}, \code{.mean}, and \code{.sum}. These modifiers
  can also be chained to create complex selections. See
  \link{treeclim-modifiers} for details.
}

For the exclusion of months, the convenience function
\code{\link{exclude_from}} (or short \code{\link{exfr}}) is
provided.

With 'dlm' one would usually try to keep the number of predictors
low.

For pretty output of the resulting linear model, parameters can be
renamed, to e.g. reflect the season they represent.
}
\examples{
dlm1 <- dlm(rt_spruce, rt_prec, .sum(6:8), param_names = "summer_prec")
summary(dlm1)

dlm2 <- dlm(rt_spruce, list(rt_prec, rt_temp),
  .sum(6:8, "prec") + .mean(6:8, "temp"), var_names = c("prec", "temp"),
  param_names = c("summer_prec", "summer_temp"))
summary(dlm2)
anova(dlm1, dlm2)
}
\author{
Christian Zang
}
