% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{combine_plot_and_tree}
\alias{combine_plot_and_tree}
\title{Method for combining two ggplots}
\usage{
combine_plot_and_tree(plot, tree.plot, tree.height = 5, print = TRUE)
}
\arguments{
\item{plot}{A plot of data about the leaves with the x axis
corresponding to leaves.}

\item{tree.plot}{A plot of the tree.}

\item{tree.height}{The relative amount of space in the plot the tree
should take up.}

\item{print}{If true, the function will print the combined plot to
a graphics device, otherwise it will just return the gtable object
without printing.}
}
\value{
Returns a \code{gtable} object.
}
\description{
This method takes a ggplot of some data along the tips of the tree
and a ggplot of a tree and combines them. It assumes that you are
putting the tree on top and that the x axis for the plot has the
leaves in the correct position (this can be found using the
function \code{\link{get_leaf_position}}).
}
