% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitCrossTerms.R
\name{fit_trawl_intersection}
\alias{fit_trawl_intersection}
\title{Finds the intersection of two trawl sets}
\usage{
fit_trawl_intersection(fct1 = base::c("Exp", "DExp", "supIG", "LM"),
  fct2 = base::c("Exp", "DExp", "supIG", "LM"), lambda11 = 0,
  lambda12 = 0, w1 = 0, delta1 = 0, gamma1 = 0, alpha1 = 0,
  H1 = 0, lambda21 = 0, lambda22 = 0, w2 = 0, delta2 = 0,
  gamma2 = 0, alpha2 = 0, H2 = 0, LM1, LM2, plotdiag = FALSE)
}
\arguments{
\item{fct1}{specifies the type of the first trawl function}

\item{fct2}{specifies the type of the second trawl function}

\item{lambda11, lambda12, w1}{parameters of the (double) exponential trawl
functions of the first process}

\item{delta1, gamma1}{parameters of the supIG trawl functions of the first
process}

\item{alpha1, H1}{parameters of the long memory trawl function of the first
process}

\item{lambda21, lambda22, w2}{parameters of the (double) exponential trawl
functions of the second process}

\item{delta2, gamma2}{parameters of the supIG trawl functions of the second
process}

\item{alpha2, H2}{parameters of the long memory trawl function of the second
process}

\item{LM1}{Lebesgue measure of the first trawl}

\item{LM2}{Lebesgue measure of the second trawl}

\item{plotdiag}{binary variable specifying whether or not diagnostic plots
should be provided}
}
\value{
The Lebesgue measure of the intersection of the two trawl sets
}
\description{
Finds the intersection of two trawl sets
}
\details{
Computes \eqn{R_{12}(0)=\mbox{Leb}(A_1 \cap A_2)} based on two trawl
 functions \eqn{g_1} and \eqn{g_2}.
}
\examples{
#Compute the intersection of two exponential trawls
fit_trawl_intersection(fct1="Exp",fct2="Exp",lambda11=0.1,lambda21=0.5,LM1=1/0.1,LM2=1/0.5)
}
