% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateDiscreteDistributions.R
\name{Bivariate_NBsim}
\alias{Bivariate_NBsim}
\title{Simulates from the bivariate negative binomial distribution}
\usage{
Bivariate_NBsim(N, kappa, p1, p2)
}
\arguments{
\item{N}{number of data points to be simulated}

\item{kappa}{parameter \eqn{\kappa} of the bivariate negative binomial distribution}

\item{p1}{parameter \eqn{p_1} of the bivariate negative binomial distribution}

\item{p2}{parameter \eqn{p_2} of the bivariate negative binomial distribution}
}
\value{
An \eqn{N\times 2} matrix with \eqn{N} simulated values from the bivariate negative
 binomial distribution
}
\description{
Simulates from the bivariate negative binomial distribution
}
\details{
A random vector \eqn{{\bf X}=(X_1,X_2)'} is said to follow the
 bivariate negative binomial distribution with parameters \eqn{\kappa, p_1,
 p_2} if its probability mass function is given by \deqn{ P({\bf X}={\bf
 x})=\frac{\Gamma(x_1+x_2+\kappa)}{x_1!x_2!
 \Gamma(\kappa)}p_1^{x_1}p_2^{x_2}(1-p_1-p_2)^{\kappa},} where,
 for \eqn{i=1,2}, \eqn{x_i\in\{0,1,\dots\}}, \eqn{0<p_i<1} such that
 \eqn{p_1+p_2<1} and \eqn{\kappa>0}.
}
\examples{
set.seed(1)
kappa <- 3
p1 <- 0.1
p2 <- 0.85
N <- 100
#Simulate N realisations from the bivariate negative binomial distribution
y <- Bivariate_NBsim(N,kappa,p1,p2)
}
