% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_7.R
\name{seqic_indicator_7}
\alias{seqic_indicator_7}
\title{SEQIC Indicator 7 - Delayed Arrival to Definitive Care}
\usage{
seqic_indicator_7(
  data,
  level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id,
  time_from_injury_to_arrival,
  transfer_out_indicator,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{time_from_injury_to_arrival}{Column name representing the time
in minutes from injury occurrence to arrival at the trauma center. Numeric
type.}

\item{transfer_out_indicator}{Column name indicating whether the patient was
transferred out of the initial trauma center to definitive care. Logical,
character, or factor type. Values representing "No" (e.g., FALSE, "No")
indicate no transfer out.}

\item{groups}{Additional columns passed as a vector of strings to
\code{dplyr::summarize()} via the \code{.by} argument for grouped summaries. Defaults
to \code{NULL}.}

\item{calculate_ci}{If \code{NULL}, 95\% confidence intervals will not be
calculated for the performance estimates.  Otherwise, options of "wilson"
or "clopper-pearson" can be supplied to utilize the corresponding methods
to calculate the confidence intervals for the proportions. Defaults to
\code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A tibble summarizing SEQIC Indicator 7 results. Includes numerator,
denominator, and proportion. 95\% confidence intervals are included if
requested.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Computes SEQIC Indicator 7, which measures the proportion of trauma patients
arriving at the definitive care facility trauma centers (level I–IV) more
than 180 minutes after injury. This indicator identifies delays in definitive
care.
}
\details{
This function:
\itemize{
\item Filters the dataset to trauma center levels I through IV.
\item Deduplicates the dataset by \code{unique_incident_id}.
\item Creates a logical flag for arrivals occurring more than 180 minutes
after injury.
\item Identifies definitive care records where the patient arrived greater
than 180 minutes after the time of injury.
\item Returns a summarized tibble with the number of such cases
(numerator), total eligible records (denominator), and the proportion.
\item Optionally includes 95\% confidence intervals if \code{calculate_ci} is
specified.
}
}
\note{
The user must ensure all columns are correctly passed and that time values
are numeric and measured in minutes.
}
\examples{
# Packages
library(dplyr)
library(traumar)

# Create test data for Indicator 7
test_data <- tibble::tibble(
  id = as.character(1:10),
  trauma_level = rep(c("I", "II", "III", "IV", "V"), times = 2),
  time_to_arrival = c(200, 100, 220, 150, 400, 181, 90, 179, 240, 178),
  transfer_out = c("No", "No", "No", "No", "Yes", "No", "No", "No", "No",
  "No")
)

# Run the indicator function
traumar::seqic_indicator_7(
  data = test_data,
  level = trauma_level,
  unique_incident_id = id,
  time_from_injury_to_arrival = time_to_arrival,
  transfer_out_indicator = transfer_out
)

}
\author{
Nicolas Foss Ed.D., MS
}
