% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taudem-exec.R
\name{taudem_exec}
\alias{taudem_exec}
\title{Call TauDEM}
\usage{
taudem_exec(
  program,
  args,
  ...,
  n_processes = getOption("traudem.n_processes", 1),
  quiet = getOption("traudem.quiet", FALSE)
)
}
\arguments{
\item{program}{TauDEM command (character). See examples.}

\item{args}{Character vector of arguments. See examples.}

\item{...}{These dots are for future extensions and must be empty.
As a consequence, all following arguments must be fully named (see examples).}

\item{n_processes}{Number of processes for \code{mpiexec}. If \code{NULL} TauDEM is called without mpiexec.}

\item{quiet}{If \code{FALSE} output from TauDEM CLI is suppressed.}
}
\value{
\code{TRUE} if the call was successful, \code{FALSE} otherwise.
}
\description{
Call TauDEM
}
\details{
You can use this function to call more TauDEM methods
than the ones with dedicated wrappers in this package.
Please refer to the relative TauDEM function documentation for the syntax used to specify optional arguments.
See also examples.
}
\examples{
\dontshow{if (interactive() && traudem::can_register_taudem()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
test_dir <- withr::local_tempdir()
dir.create(test_dir)
file.copy(
   system.file("test-data", "DEM.tif", package = "traudem"),
   file.path(test_dir, "DEM.tif")
 )
 # Default name for output file, only input command and input filename.
taudem_exec("pitremove", file.path(test_dir, "DEM.tif"))

# syntax for user-attributed output file name
taudem_exec(
  "pitremove",
  c(
    "-z", file.path(test_dir, "DEM.tif"),
    "-fel", file.path(test_dir,"filled_pits.tif")
  )
)
\dontshow{\}) # examplesIf}
}
