% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transGFM.R
\name{identify}
\alias{identify}
\title{Identify factor decomposition via SVD}
\usage{
identify(M, r)
}
\arguments{
\item{M}{Matrix to decompose}

\item{r}{Number of factors}
}
\value{
List with F (row factors) and B (column factors)
}
\description{
Identify factor decomposition via SVD
}
\examples{
# Generate Poisson data
set.seed(123)
n0 <- 50; p0 <- 50; r <- 2
F_true <- matrix(runif(n0 * r, min = -2, max = 2), n0, r)
B_true <- matrix(runif(p0 * r, min = -2, max = 2), p0, r)
F_true <- F_true / sqrt(r)
B_true <- B_true / sqrt(r)
M_true <- F_true \%*\% t(B_true)

# Decompose using identify
result <- identify(M_true, r = 2)
F_hat <- result$F
B_hat <- result$B

# Check reconstruction
M_reconstructed <- F_hat \%*\% t(B_hat)
print(max(abs(M_reconstructed - M_true)))  # Should be very small

}
