% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvregME.R
\name{SurvregME}
\alias{SurvregME}
\title{Mixed-effects Additive Parametric Survival Models}
\usage{
SurvregME(
  formula,
  data,
  subset,
  weights,
  offset,
  na.action = na.omit,
  dist = c("weibull", "logistic", "gaussian", "exponential", "rayleigh", "loggaussian",
    "lognormal", "loglogistic"),
  scale = 0,
  silent = TRUE,
  resid = FALSE,
  do_update = FALSE,
  estinit = TRUE,
  initpar = NULL,
  fixed = NULL,
  nofit = FALSE,
  control = optim_control(),
  ...
)
}
\arguments{
\item{formula}{A formula describing the model. Smooth additive terms are
defined the way as in \code{mgcv}, and random effects consistently with
the notation used in \code{lme4}.}

\item{data}{an optional data frame, list or environment (or object
          coercible by \code{as.data.frame} to a data frame) containing the
          variables in the model.  If not found in \code{data}, the
          variables are taken from \code{environment(formula)}.
  }

\item{subset}{an optional vector specifying a subset of observations to be
          used in the fitting process.
  }

\item{weights}{an optional vector of case weights to be used in the fitting
          process.  Should be \code{NULL} or a numeric vector. If present,
          the weighted log-likelihood is maximised.
  }

\item{offset}{this can be used to specify an _a priori_ known component to
          be included in the linear predictor during fitting.  This
          should be \code{NULL} or a numeric vector of length equal to the
          number of cases.
  }

\item{na.action}{a function which indicates what should happen when the data
          contain \code{NA}s.  The default is set to \code{na.omit}.
  }

\item{dist}{character defining the conditional distribution of the
    (not necessarily positive) response, current choices include 
    Weibull, logistic, normal, exponential, Rayleigh, log-normal (same as
    log-gaussian), or log-logistic.
  }

\item{scale}{a fixed value for the scale parameter(s).
  }

\item{silent}{Logical. Make \pkg{TMB} functionality silent.}

\item{resid}{Logical. If \code{TRUE}, the score residuals are also calculated.
This comes with some performance cost.}

\item{do_update}{Logical. If \code{TRUE}, the model is set up so that the weights and the
offsets are updateable. This comes with some performance cost.}

\item{estinit}{Logical. Estimate a vector of initial values for the fixed effects parameters
from a (fixed effects only) mlt model}

\item{initpar}{Named list of initial parameter values, if \code{NULL}, it is ignored}

\item{fixed}{a named vector of fixed regression coefficients; the names
               need to correspond to column names of the design matrix}

\item{nofit}{logical, if TRUE, creates the model object, but does not run the optimization}

\item{control}{list with controls for optimization}

\item{...}{Optional arguments to \code{\link[tram]{tram}}}
}
\value{
A \code{SurvregME} model object.
}
\description{
Estimates various mixed-effects additive parametric models (not exclusively)
for survival analysis.
}
\details{
The parameterization is slightly different from
  \code{\link[survival:survreg]{survival::survreg}}, see Hothorn et al.
  (2018).  The results can be transformed back to the \code{survreg}
  parameterization with specific methods provided by \code{tramME}.

The model extends \code{\link[tram:Survreg]{tram::Survreg}} with random
  effects and (optionally penalized) additive terms. For details on
  mixed-effect transformation models, see Tamasi and Hothorn (2021).

The elements of the linear predictor are parameterized with negative
  parameters (i.e. \code{negative = TRUE} in \code{\link[tram]{tram}}).
}
\examples{
library("survival")
rats$litter <- factor(rats$litter)
m <- SurvregME(Surv(time, status) ~ rx + (1 | litter), data = rats,
               dist = "weibull")
summary(m)
coef(m, as.survreg = TRUE)
}
\references{
Hothorn, Torsten, Lisa Möst, and Peter Bühlmann. "Most Likely
  Transformations."  Scandinavian Journal of Statistics 45, no. 1 (March
  2018): 110–34.  <doi:10.1111/sjos.12291>

Tamasi, Balint, and Torsten Hothorn. "tramME: Mixed-Effects Transformation
  Models Using Template Model Builder." The R Journal 13, no. 2 (2021):
  398–418. <doi:10.32614/RJ-2021-075>
}
