% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.tramME}
\alias{coef.tramME}
\title{Extract the coefficients of the fixed effects terms.}
\usage{
\method{coef}{tramME}(object, with_baseline = FALSE, fixed = TRUE, ...)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{with_baseline}{If \code{TRUE}, also include the baseline parameters.}

\item{fixed}{If \code{TRUE}, also include the fixed parameters.}

\item{...}{Optional parameters (ignored).}
}
\value{
Numeric vector of parameter values.
}
\description{
Extract the coefficients of the fixed effects terms.
}
\examples{
library("survival")
mod <- SurvregME(Surv(time, status) ~ rx + (1 | litter/rx), data = rats,
                 dist = "exponential", nofit = TRUE)
coef(mod, with_baseline = TRUE)
coef(mod, with_baseline = TRUE, fixed = FALSE)
}
