% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_usda.R
\name{tr_usda}
\alias{tr_usda}
\title{USDA plants data}
\usage{
tr_usda(query = list(), limit = 30, offset = 0, fields = NULL, ...)
}
\arguments{
\item{query}{(character) query terms in a named list}

\item{limit}{(integer) number of records to return}

\item{offset}{(integer) record number to start at}

\item{fields}{(character) vector of fields to return, case sensitive}

\item{...}{Curl options passed on to [crul::HttpClient()]}
}
\value{
list, with metadata fields ("count", "returned", "citation",
"terms"), and a data.frame in "data"
}
\description{
USDA plants data
}
\details{
beware: this data is a bit old, from a dump of their data
from a while back.
}
\examples{
\dontrun{
tr_usda(query = list(genus = "Magnolia"))
tr_usda(query = list(genus = "Magnolia", species = "grandiflora"))

tr_usda(limit = 30)
tr_usda(limit = 3)
tr_usda(limit = 3, offset = 3)

tr_usda(fields = c('Id', 'Symbol', 'Genus', 'Species'))
}
}
\references{
https://plantsdb.xyz, https://github.com/sckott/usdaplantsapi
}
