% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_query.R
\name{track_query}
\alias{track_query}
\title{Query track data for arbitrary locations}
\usage{
track_query(x, y, date = NULL, query, type = "linear")
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}

\item{date}{date-time in POSIXct (or can be ignore, for relative index-time)}

\item{query}{required argument, date-time values to return inferred x, y positions for}

\item{type}{linear, geodesic, rhumb, forward, backward, nearest (also need open/closed intervals)}
}
\description{
Latent positions may be queried using arbitrary date-time values. The only method
(for now) is 'linear', but default should be 'geodesic'. In time we include more methods
to match the GeoPandas implementation.
}
\details{
If \code{date} is not included, time itself is treated as the obvious index on n-locations so
simple relative time, and \code{query} is expected to match this.

We use group_modify to keep the id groups:
\code{trips0 \%>\% group_by(id) \%>\% group_modify(~track_query(.x$x, .x$y, query = c(4.5, 6.7)))}
}
\examples{
track_query(trips0$x[1:10], trips0$y[1:10], query = c(4.5, 5.5, 6.5))
track_query(trips0$x[1:10], trips0$y[1:10], trips0$date[1:10], query = trips0$date[1:10] + 10)
s <- seq(min(trips0$date), max(trips0$date), by = "1 hour")
}
