% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tripSummary.r
\name{tripSummary}
\alias{tripSummary}
\title{Summary of trip movements}
\usage{
tripSummary(trips, colony = NULL, nests = FALSE, extraDist = FALSE)
}
\arguments{
\item{trips}{SpatialPointsDataFrame, as produced by \code{\link{tripSplit}}.}

\item{colony}{data.frame with 'Latitude' and 'Longitude' columns specifying
the locations of the central place (e.g. breeding colony). If
\code{nests=TRUE}, \code{colony} should have a third column, 'ID'
with corresponding character values in the 'ID' field in \emph{trips}.}

\item{nests}{logical scalar (TRUE/FALSE). Were central place
(e.g. deployment) locations used in \code{tripSplit} specific to each unique
 'ID'? If so, each place must be matched with an 'ID' value in both
 \code{trips} and \code{colony} objects.}

\item{extraDist}{logical scalar (TRUE/FALSE). If TRUE, the distance between
the first and last points of each trip and the \code{colony} will be added to
the 'total_dist' (total distance travelled) for each trip.}
}
\value{
Returns a tibble data.frame grouped by ID. Trip characteristics
included are trip duration (in hours), maximum distance and cumulative
distance travelled (in kilometers), direction (in degrees, measured from
origin to furthest point of track), start and end times as well as a unique
trip identifier ('tripID') for each trip performed by each individual in the
 data set. Distances are calculated on a great circle.

If the beginning of a track is starts out on a trip which is followed by only
 one point within \emph{InnerBuff}, this is considered an 'incomplete' trip
 and will have an NA for duration. If an animal leaves on a trip but does not
 return within the \emph{ReturnBuff} this will be also classified an
 'incomplete trip'.
}
\description{
\code{tripSummary} provides a simple summary of foraging trip distances,
durations, and directions performed by central place foraging animals.
}
\details{
\emph{nests}=T may be used if it is desired, for example, to use specific
nest locations instead of one central location for all individuals/tracks.
}
\examples{
## make some play data
dataGroup <- data.frame(Longitude = rep(c(1:10, 10:1), 2), 
               Latitude =  rep(c(1:10, 10:1), 2),
               ID = c(rep("A", 20), rep("B", 20)),
               DateTime = as.character(
               lubridate::ymd_hms("2021-01-01 00:00:00") + 
               lubridate::hours(0:19))
)

colony <- data.frame(
Longitude = dataGroup$Longitude[1], Latitude = dataGroup$Latitude[1]
)
## split tracks into trips
trips <- tripSplit(dataGroup, colony=colony, 
                innerBuff = 1, 
                returnBuff = 1, 
                duration = 0.5,
                rmNonTrip = FALSE
)
## summarise trip characteristics
sumTrips <- tripSummary(trips, colony)

}
\seealso{
\code{\link{tripSplit}}
}
