% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_max_pool3d}
\alias{nn_max_pool3d}
\title{Applies a 3D max pooling over an input signal composed of several input
planes.}
\usage{
nn_max_pool3d(
  kernel_size,
  stride = NULL,
  padding = 0,
  dilation = 1,
  return_indices = FALSE,
  ceil_mode = FALSE
)
}
\arguments{
\item{kernel_size}{the size of the window to take a max over}

\item{stride}{the stride of the window. Default value is \code{kernel_size}}

\item{padding}{implicit zero padding to be added on all three sides}

\item{dilation}{a parameter that controls the stride of elements in the window}

\item{return_indices}{if \code{TRUE}, will return the max indices along with the outputs.
Useful for \code{torch_nn.MaxUnpool3d} later}

\item{ceil_mode}{when TRUE, will use \code{ceil} instead of \code{floor} to compute the output shape}
}
\description{
In the simplest case, the output value of the layer with input size \eqn{(N, C, D, H, W)},
output \eqn{(N, C, D_{out}, H_{out}, W_{out})} and \code{kernel_size} \eqn{(kD, kH, kW)}
can be precisely described as:
}
\details{
\deqn{
\begin{array}{ll}
\mbox{out}(N_i, C_j, d, h, w) = & \max_{k=0, \ldots, kD-1} \max_{m=0, \ldots, kH-1} \max_{n=0, \ldots, kW-1} \\
 & \mbox{input}(N_i, C_j, \mbox{stride[0]} \times d + k, \mbox{stride[1]} \times h + m, \mbox{stride[2]} \times w + n)
\end{array}
}

If \code{padding} is non-zero, then the input is implicitly zero-padded on both sides
for \code{padding} number of points. \code{dilation} controls the spacing between the kernel points.
It is harder to describe, but this \code{link}_ has a nice visualization of what \code{dilation} does.
The parameters \code{kernel_size}, \code{stride}, \code{padding}, \code{dilation} can either be:
\itemize{
\item a single \code{int} -- in which case the same value is used for the depth, height and width dimension
\item a \code{tuple} of three ints -- in which case, the first \code{int} is used for the depth dimension,
the second \code{int} for the height dimension and the third \code{int} for the width dimension
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, D_{in}, H_{in}, W_{in})}
\item Output: \eqn{(N, C, D_{out}, H_{out}, W_{out})}, where
\deqn{
  D_{out} = \left\lfloor\frac{D_{in} + 2 \times \mbox{padding}[0] - \mbox{dilation}[0] \times
    (\mbox{kernel\_size}[0] - 1) - 1}{\mbox{stride}[0]} + 1\right\rfloor
}
}

\deqn{
  H_{out} = \left\lfloor\frac{H_{in} + 2 \times \mbox{padding}[1] - \mbox{dilation}[1] \times
    (\mbox{kernel\_size}[1] - 1) - 1}{\mbox{stride}[1]} + 1\right\rfloor
}

\deqn{
  W_{out} = \left\lfloor\frac{W_{in} + 2 \times \mbox{padding}[2] - \mbox{dilation}[2] \times
    (\mbox{kernel\_size}[2] - 1) - 1}{\mbox{stride}[2]} + 1\right\rfloor
}
}

\examples{
if (torch_is_installed()) {
# pool of square window of size=3, stride=2
m <- nn_max_pool3d(3, stride=2)
# pool of non-square window
m <- nn_max_pool3d(c(3, 2, 2), stride=c(2, 1, 2))
input <- torch_randn(20, 16, 50,44, 31)
output <- m(input)

}
}
