% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_inv}
\alias{linalg_inv}
\title{Computes the inverse of a square matrix if it exists.}
\usage{
linalg_inv(A)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions
consisting of invertible matrices.}
}
\description{
Throws a \code{runtime_error} if the matrix is not invertible.
}
\details{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
for a matrix \teqn{A \in \mathbb{K}^{n \times n}},
its \strong{inverse matrix} \teqn{A^{-1} \in \mathbb{K}^{n \times n}} (if it exists) is defined as

\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
A^{-1}A = AA^{-1} = \\\\mathrm{I}_n
")}
where \teqn{\mathrm{I}_n} is the \code{n}-dimensional identity matrix.

The inverse matrix exists if and only if \teqn{A} is invertible. In this case,
the inverse is unique.
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices
then the output has the same batch dimensions.

Consider using \code{\link[=linalg_solve]{linalg_solve()}} if possible for multiplying a matrix on the left by
the inverse, as \code{linalg_solve(A, B) == A$inv() \%*\% B}
It is always prefered to use \code{\link[=linalg_solve]{linalg_solve()}} when possible, as it is faster and more
numerically stable than computing the inverse explicitly.
}
\examples{
if (torch_is_installed()) {
A <- torch_randn(4, 4)
linalg_inv(A)

}
}
\seealso{
\code{\link[=linalg_pinv]{linalg_pinv()}} computes the pseudoinverse (Moore-Penrose inverse) of matrices
of any shape.
\code{\link[=linalg_solve]{linalg_solve()}} computes \code{A$inv() \%*\% B} with a
numerically stable algorithm.

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
