% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-categorical.R
\name{distr_categorical}
\alias{distr_categorical}
\title{Creates a categorical distribution parameterized by either \code{probs} or
\code{logits} (but not both).}
\usage{
distr_categorical(probs = NULL, logits = NULL, validate_args = NULL)
}
\arguments{
\item{probs}{(Tensor): event probabilities}

\item{logits}{(Tensor): event log probabilities (unnormalized)}

\item{validate_args}{Additional arguments}
}
\description{
Creates a categorical distribution parameterized by either \code{probs} or
\code{logits} (but not both).
}
\note{
It is equivalent to the distribution that \code{\link[=torch_multinomial]{torch_multinomial()}}
samples from.

Samples are integers from \eqn{\{0, \ldots, K-1\}} where \code{K} is \code{probs$size(-1)}.

If \code{probs} is 1-dimensional with length-\code{K}, each element is the relative probability
of sampling the class at that index.

If \code{probs} is N-dimensional, the first N-1 dimensions are treated as a batch of
relative probability vectors.

The \code{probs} argument must be non-negative, finite and have a non-zero sum,
and it will be normalized to sum to 1 along the last dimension. attr:\code{probs}
will return this normalized value.
The \code{logits} argument will be interpreted as unnormalized log probabilities
and can therefore be any real number. It will likewise be normalized so that
the resulting probabilities sum to 1 along the last dimension. attr:\code{logits}
will return this normalized value.

See also: \code{\link[=torch_multinomial]{torch_multinomial()}}
}
\examples{
if (torch_is_installed()) {
m <- distr_categorical(torch_tensor(c(0.25, 0.25, 0.25, 0.25)))
m$sample()  # equal probability of 1,2,3,4

}
}
