% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_hardtanh}
\alias{nn_hardtanh}
\title{Hardtanh module}
\usage{
nn_hardtanh(min_val = -1, max_val = 1, inplace = FALSE)
}
\arguments{
\item{min_val}{minimum value of the linear region range. Default: -1}

\item{max_val}{maximum value of the linear region range. Default: 1}

\item{inplace}{can optionally do the operation in-place. Default: \code{FALSE}}
}
\description{
Applies the HardTanh function element-wise
HardTanh is defined as:
}
\details{
\deqn{
\mbox{HardTanh}(x) = \left\{ \begin{array}{ll}
  1 & \mbox{ if } x > 1 \\
  -1 & \mbox{ if } x < -1 \\
  x & \mbox{ otherwise } \\
\end{array}
\right.
}

The range of the linear region :math:\verb{[-1, 1]} can be adjusted using
\code{min_val} and \code{max_val}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_hardtanh(-2, 2)
input <- torch_randn(2)
output <- m(input)

}
}
