% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_vstack}
\alias{torch_vstack}
\title{Vstack}
\usage{
torch_vstack(tensors)
}
\arguments{
\item{tensors}{(sequence of Tensors) sequence of tensors to concatenate}
}
\description{
Vstack
}
\section{vstack(tensors, *, out=None) -> Tensor }{


Stack tensors in sequence vertically (row wise).

This is equivalent to concatenation along the first axis after all 1-D tensors
have been reshaped by \code{\link[=torch_atleast_2d]{torch_atleast_2d()}}.
}

\examples{
if (torch_is_installed()) {

a <- torch_tensor(c(1, 2, 3))
b <- torch_tensor(c(4, 5, 6))
torch_vstack(list(a,b))
a <- torch_tensor(rbind(1,2,3))
b <- torch_tensor(rbind(4,5,6))
torch_vstack(list(a,b))
}
}
