% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_cross_entropy_loss}
\alias{nn_cross_entropy_loss}
\title{CrossEntropyLoss module}
\usage{
nn_cross_entropy_loss(weight = NULL, ignore_index = -100, reduction = "mean")
}
\arguments{
\item{weight}{(Tensor, optional): a manual rescaling weight given to each class.
If given, has to be a Tensor of size \code{C}}

\item{ignore_index}{(int, optional): Specifies a target value that is ignored
and does not contribute to the input gradient. When \code{size_average} is
\code{TRUE}, the loss is averaged over non-ignored targets.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed.}
}
\description{
This criterion combines \code{\link[=nn_log_softmax]{nn_log_softmax()}} and \code{nn_nll_loss()} in one single class.
It is useful when training a classification problem with \code{C} classes.
}
\details{
If provided, the optional argument \code{weight} should be a 1D \code{Tensor}
assigning weight to each of the classes.

This is particularly useful when you have an unbalanced training set.
The \code{input} is expected to contain raw, unnormalized scores for each class.
\code{input} has to be a Tensor of size either \eqn{(minibatch, C)} or
\eqn{(minibatch, C, d_1, d_2, ..., d_K)}
with \eqn{K \geq 1} for the \code{K}-dimensional case (described later).

This criterion expects a class index in the range \eqn{[0, C-1]} as the
\code{target} for each value of a 1D tensor of size \code{minibatch}; if \code{ignore_index}
is specified, this criterion also accepts this class index (this index may not
necessarily be in the class range).

The loss can be described as:
\deqn{
  \mbox{loss}(x, class) = -\log\left(\frac{\exp(x[class])}{\sum_j \exp(x[j])}\right)
= -x[class] + \log\left(\sum_j \exp(x[j])\right)
}
or in the case of the \code{weight} argument being specified:
\deqn{
  \mbox{loss}(x, class) = weight[class] \left(-x[class] + \log\left(\sum_j \exp(x[j])\right)\right)
}

The losses are averaged across observations for each minibatch.
Can also be used for higher dimension inputs, such as 2D images, by providing
an input of size \eqn{(minibatch, C, d_1, d_2, ..., d_K)} with \eqn{K \geq 1},
where \eqn{K} is the number of dimensions, and a target of appropriate shape
(see below).
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C)} where \verb{C = number of classes}, or
\eqn{(N, C, d_1, d_2, ..., d_K)} with \eqn{K \geq 1}
in the case of \code{K}-dimensional loss.
\item Target: \eqn{(N)} where each value is \eqn{0 \leq \mbox{targets}[i] \leq C-1}, or
\eqn{(N, d_1, d_2, ..., d_K)} with \eqn{K \geq 1} in the case of
K-dimensional loss.
\item Output: scalar.
If \code{reduction} is \code{'none'}, then the same size as the target:
\eqn{(N)}, or
\eqn{(N, d_1, d_2, ..., d_K)} with \eqn{K \geq 1} in the case
of K-dimensional loss.
}
}

\examples{
if (torch_is_installed()) {
loss <- nn_cross_entropy_loss()
input <- torch_randn(3, 5, requires_grad = TRUE)
target <- torch_randint(low = 1, high = 5, size = 3, dtype = torch_long())
output <- loss(input, target)
output$backward()
}
}
