% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{get_install_libs_url}
\alias{get_install_libs_url}
\alias{install_torch_from_file}
\title{Install Torch from files}
\usage{
get_install_libs_url(version = NA, type = NA)

install_torch_from_file(version = NA, type = NA, libtorch, liblantern, ...)
}
\arguments{
\item{version}{Not used}

\item{type}{Not used. This function is deprecated.}

\item{libtorch}{The installation archive file to use for Torch. Shall be a \code{"file://"} URL scheme.}

\item{liblantern}{The installation archive file to use for Lantern. Shall be a \code{"file://"} URL scheme.}

\item{...}{other parameters to be passed to \code{"install_torch()"}}
}
\description{
List the Torch and Lantern libraries URLs to download as local files in order to proceed with  \code{install_torch_from_file()}.

Installs Torch and its dependencies from files.
}
\details{
When \code{"install_torch()"} initiated download is not possible, but installation archive files are
present on local filesystem, \code{"install_torch_from_file()"} can be used as a workaround to installation issue.
\code{"libtorch"} is the archive containing all torch modules, and \code{"liblantern"} is the C interface to libtorch
that is used for the R package. Both are highly dependent, and should be checked through \code{"get_install_libs_url()"}
}
\examples{
if (torch_is_installed()) {
\dontrun{
# on a linux CPU platform 
get_install_libs_url()
# then after making both files available into /tmp/
Sys.setenv(TORCH_URL="/tmp/libtorch-v1.13.1.zip")
Sys.setenv(LANTERN_URL="/tmp/lantern-0.9.1.9001+cpu+arm64-Darwin.zip")
torch::install_torch()
}
}
}
