% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_acosh}
\alias{torch_acosh}
\title{Acosh}
\usage{
torch_acosh(self)
}
\arguments{
\item{self}{(Tensor) the input tensor.}
}
\description{
Acosh
}
\note{
The domain of the inverse hyperbolic cosine is \verb{[1, inf)} and values outside this range
will be mapped to \code{NaN}, except for \code{+ INF} for which the output is mapped to \code{+ INF}.

\deqn{
    \mbox{out}_{i} = \cosh^{-1}(\mbox{input}_{i})
}
}
\section{acosh(input, *, out=None) -> Tensor }{


Returns a new tensor with the inverse hyperbolic cosine of the elements of \code{input}.
}

\examples{
if (torch_is_installed()) {

a <- torch_randn(c(4))$uniform_(1, 2)
a
torch_acosh(a)
}
}
