% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_addmm}
\alias{torch_addmm}
\title{Addmm}
\usage{
torch_addmm(self, mat1, mat2, beta = 1L, alpha = 1L)
}
\arguments{
\item{self}{(Tensor) matrix to be added}

\item{mat1}{(Tensor) the first matrix to be multiplied}

\item{mat2}{(Tensor) the second matrix to be multiplied}

\item{beta}{(Number, optional) multiplier for \code{input} (\eqn{\beta})}

\item{alpha}{(Number, optional) multiplier for \eqn{mat1 @ mat2} (\eqn{\alpha})}
}
\description{
Addmm
}
\section{addmm(input, mat1, mat2, *, beta=1, alpha=1, out=NULL) -> Tensor }{


Performs a matrix multiplication of the matrices \code{mat1} and \code{mat2}.
The matrix \code{input} is added to the final result.

If \code{mat1} is a \eqn{(n \times m)} tensor, \code{mat2} is a
\eqn{(m \times p)} tensor, then \code{input} must be
broadcastable  with a \eqn{(n \times p)} tensor
and \code{out} will be a \eqn{(n \times p)} tensor.

\code{alpha} and \code{beta} are scaling factors on matrix-vector product between
\code{mat1} and \code{mat2} and the added matrix \code{input} respectively.

\deqn{
    \mbox{out} = \beta\ \mbox{input} + \alpha\ (\mbox{mat1}_i \mathbin{@} \mbox{mat2}_i)
}
For inputs of type \code{FloatTensor} or \code{DoubleTensor}, arguments \code{beta} and
\code{alpha} must be real numbers, otherwise they should be integers.
}

\examples{
if (torch_is_installed()) {

M = torch_randn(c(2, 3))
mat1 = torch_randn(c(2, 3))
mat2 = torch_randn(c(3, 3))
torch_addmm(M, mat1, mat2)
}
}
