% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_kthvalue}
\alias{torch_kthvalue}
\title{Kthvalue}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{k}{(int) k for the k-th smallest element}

\item{dim}{(int, optional) the dimension to find the kth value along}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{out}{(tuple, optional) the output tuple of (Tensor, LongTensor)                           can be optionally given to be used as output buffers}
}
\description{
Kthvalue
}
\section{kthvalue(input, k, dim=None, keepdim=False, out=None) -> (Tensor, LongTensor) }{


Returns a namedtuple \verb{(values, indices)} where \code{values} is the \code{k} th
smallest element of each row of the \code{input} tensor in the given dimension
\code{dim}. And \code{indices} is the index location of each element found.

If \code{dim} is not given, the last dimension of the \code{input} is chosen.

If \code{keepdim} is \code{True}, both the \code{values} and \code{indices} tensors
are the same size as \code{input}, except in the dimension \code{dim} where
they are of size 1. Otherwise, \code{dim} is squeezed
(see \code{\link{torch_squeeze}}), resulting in both the \code{values} and
\code{indices} tensors having 1 fewer dimension than the \code{input} tensor.
}

\examples{
if (torch_is_installed()) {

x = torch_arange(1., 6.)
x
torch_kthvalue(x, 4)
x=torch_arange(1.,7.)$resize_(c(2,3))
x
torch_kthvalue(x, 2, 1, TRUE)
}
}
