% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-pooling.R
\name{nnf_max_pool2d}
\alias{nnf_max_pool2d}
\title{Max_pool2d}
\usage{
nnf_max_pool2d(
  input,
  kernel_size,
  stride = kernel_size,
  padding = 0,
  dilation = 1,
  ceil_mode = FALSE,
  return_indices = FALSE
)
}
\arguments{
\item{input}{input tensor (minibatch, in_channels , iH , iW)}

\item{kernel_size}{size of the pooling region. Can be a single number or a
tuple \verb{(kH, kW)}}

\item{stride}{stride of the pooling operation. Can be a single number or a
tuple \verb{(sH, sW)}. Default: \code{kernel_size}}

\item{padding}{implicit zero paddings on both sides of the input. Can be a
single number or a tuple \verb{(padH, padW)}. Default: 0}

\item{dilation}{controls the spacing between the kernel points; also known as
the à trous algorithm.}

\item{ceil_mode}{when True, will use \code{ceil} instead of \code{floor} in the formula
to compute the output shape. Default: \code{FALSE}}

\item{return_indices}{whether to return the indices where the max occurs.}
}
\description{
Applies a 2D max pooling over an input signal composed of several input
planes.
}
