% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{table_to_matrix}
\alias{table_to_matrix}
\title{Convert Table Format Data to Dissimilarity Matrix}
\usage{
table_to_matrix(data, is_similarity = FALSE)
}
\arguments{
\item{data}{Matrix or data frame where rownames represent objects, columnnames represent
references, and cells contain (dis)similarity values.}

\item{is_similarity}{Logical. Whether values are similarities (TRUE) or dissimilarities (FALSE).
If TRUE, similarities will be converted to dissimilarities by subtracting from the
maximum value per column (reference). Default: FALSE.}
}
\value{
A symmetric matrix of dissimilarities with row and column names
corresponding to the union of all object and reference names.
NA values represent unmeasured pairs, and the diagonal is set to 0.
}
\description{
Converts data from table/matrix format (objects as rows, references as columns)
to a symmetric dissimilarity matrix. The function creates a matrix where both
rows and columns contain the union of all object and reference names.
}
\details{
The function takes a table where:
\itemize{
\item Rows represent objects
\item Columns represent references
\item Values represent (dis)similarities
}

It creates a symmetric matrix where both rows and columns contain the union of
all object names (row names) and reference names (column names). The original
measurements are preserved, and the matrix is made symmetric by filling both
(i,j) and (j,i) positions with the same value.

When \code{is_similarity = TRUE}, similarities are converted to dissimilarities by
subtracting each value from the maximum value in its respective column (reference).
Threshold indicators (< or >) are handled and inverted during conversion.
}
\examples{
# Example with dissimilarity data in table format
dissim_table <- matrix(c(1.2, 2.1, 3.4, 1.8, 2.9, 4.1),
                      nrow = 2, ncol = 3,
                      dimnames = list(c("Obj1", "Obj2"),
                                    c("Ref1", "Ref2", "Ref3")))

mat_dissim <- table_to_matrix(dissim_table, is_similarity = FALSE)

# Example with similarity data (will be converted to dissimilarity)
sim_table <- matrix(c(8.8, 7.9, 6.6, 8.2, 7.1, 5.9),
                   nrow = 2, ncol = 3,
                   dimnames = list(c("Obj1", "Obj2"),
                                 c("Ref1", "Ref2", "Ref3")))

mat_from_sim <- table_to_matrix(sim_table, is_similarity = TRUE)

}
