% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot.topolow_convergence}
\alias{plot.topolow_convergence}
\title{Plot Method for topolow Convergence Diagnostics}
\usage{
\method{plot}{topolow_convergence}(x, param_names = NULL, ...)
}
\arguments{
\item{x}{A \code{topolow_convergence} object from \code{check_gaussian_convergence()}.}

\item{param_names}{Optional character vector of parameter names for plot titles.
If NULL, names are taken from the input object.}

\item{...}{Additional arguments (not currently used).}
}
\value{
A grid of plots showing convergence metrics.
}
\description{
Creates visualizations of convergence diagnostics from a sampling run, including
parameter mean trajectories and covariance matrix stability over iterations. This helps
assess whether parameter estimation has converged.
}
\details{
The function generates two types of plots:
\enumerate{
\item Parameter mean plots: Shows how the mean value for each parameter changes over iterations.
Stabilization of these plots indicates convergence.
\item Covariance change plot: Shows the relative change in the Frobenius norm of the
covariance matrix. A decreasing trend approaching zero indicates stable relationships
between parameters.
}
}
\examples{
# Example with simulated data
chain_data <- data.frame(
  param1 = rnorm(1000, mean = 1.5, sd = 0.1),
  param2 = rnorm(1000, mean = -0.5, sd = 0.2)
)

# Check convergence
results <- check_gaussian_convergence(chain_data)

# Plot diagnostics
plot(results)

# With custom parameter names
plot(results, param_names = c("Parameter 1 (log)", "Parameter 2 (log)"))

}
\seealso{
\code{\link{check_gaussian_convergence}} for generating the convergence object.
}
