% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoSurface.R
\name{topoSurface}
\alias{topoSurface}
\title{Topographic distance surface}
\usage{
topoSurface(DEM, conductance = TRUE, directions = 8, zweight = 1)
}
\arguments{
\item{DEM}{A RasterLayer for digital elevation model (DEM) data.}

\item{conductance}{logical (default = TRUE). If FALSE, resistance values are returned.  If TRUE, conductance values (1/resistance) are returned.}

\item{directions}{numeric (default = 8). Directions of allowable movement between raster cells (4 or 8).}

\item{zweight}{numeric (default = 1). The weight to be applied to the elevation (z) distances relative to the horizontal (xy) distances.}
}
\value{
TransitionLayer
}
\description{
Generates a TransitionLayer object for topographic distance from a RasterLayer
}
\details{
This function generates a TransitionLayer from a DEM, which is used by the topoDist and topoLCP functions.  It does not need to be called separately from the topoDist and topoLCP functions.
}
\examples{
YosTL <- topoSurface(Yosemite$DEM)
}
