\name{tolerance-package}
\alias{tolerance-package}
\alias{tolerance}
\docType{package}
\title{
Statistical Tolerance Intervals and Regions
}
\description{
Statistical tolerance limits provide the limits between which we can expect to find a specified proportion of a sampled population with a given level of confidence.  This package provides functions for estimating tolerance limits (intervals) for various univariate distributions (binomial, Cauchy, discrete Pareto, exponential, two-parameter exponential, extreme value, hypergeometric, Laplace, logistic, negative binomial, negative hypergeometric, normal, Pareto, Poisson-Lindley, Poisson, uniform, and Zipf-Mandelbrot), Bayesian normal tolerance limits, multivariate normal tolerance regions, nonparametric tolerance intervals, tolerance bands for regression settings (linear regression, nonlinear regression, nonparametric regression, and multivariate regression), and analysis of variance tolerance intervals.  Visualizations are also available for most of these settings.
}
\details{
\tabular{ll}{
Package: \tab tolerance\cr
Type: \tab Package\cr
Version: \tab 1.3.0\cr
Date: \tab 2017-02-03\cr
Imports: \tab rgl, stats4\cr
License: \tab GPL (>= 2)\cr
}
}
\author{
Derek S. Young, Ph.D.

Maintainer: Derek S. Young <derek.young@uky.edu>
}
\seealso{
  \code{\link{confint}}
}
\references{
  Hahn, G. J. and Meeker, W. Q. (1991), \emph{Statistical Intervals: A Guide for Practitioners}, Wiley-Interscience.

  Krishnamoorthy, K. and Mathew, T. (2009), \emph{Statistical Tolerance Regions: Theory, Applications, and Computation}, Wiley.

  Patel, J. K. (1986), Tolerance Intervals - A Review, \emph{Communications in Statistics - Theory and Methodology},
  \bold{15}, 2719--2762.
  
  Young, D. S. (2010), \code{tolerance:} An \code{R} Package for Estimating Tolerance Intervals, \emph{Journal of Statistical Software}, \bold{36}(5), 1--39.
  
  Young, D. S. (2014), Computing Tolerance Intervals and Regions in \code{R}. In M. B. Rao and C. R. Rao (eds.), \emph{Handbook of Statistics, Volume 32: Computational Statistics with \code{R}}, 309--338. North-Holland, Amsterdam.
}

