% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-utils.R
\name{cal_events}
\alias{cal_events}
\title{Calendar custom JavaScript events}
\usage{
cal_events(
  cal,
  afterRenderSchedule = NULL,
  beforeCreateSchedule = NULL,
  beforeDeleteSchedule = NULL,
  beforeUpdateSchedule = NULL,
  clickDayname = NULL,
  clickMorecalendar = NULL,
  clickSchedule = NULL,
  clickTimezonesCollapseBtncalendar = NULL
)
}
\arguments{
\item{cal}{A \code{calendar} htmlwidget object.}

\item{afterRenderSchedule}{Fire this event by every single schedule after rendering whole calendar.}

\item{beforeCreateSchedule}{Fire this event when select time period in daily, weekly, monthly.}

\item{beforeDeleteSchedule}{Fire this event when delete a schedule.}

\item{beforeUpdateSchedule}{Fire this event when drag a schedule to change time in daily, weekly, monthly.}

\item{clickDayname}{Fire this event when click a day name in weekly.}

\item{clickMorecalendar}{Fire this event when click a schedule.}

\item{clickSchedule}{Fire this event when click a schedule.}

\item{clickTimezonesCollapseBtncalendar}{Fire this event by clicking timezones collapse button.}
}
\value{
A \code{calendar} htmlwidget object.
}
\description{
Currently only works in Shiny applications.
}
\note{
All arguments must be JavaScript function wrapped in \code{\link[htmlwidgets:JS]{htmlwidgets::JS()}}.
}
\examples{
library(shiny)
library(toastui)

calendarProps <- data.frame(
  id = c("1", "2", "3"),
  name = c("TODO", "Meetings", "Tasks"),
  color = c("#FFF", "#FFF", "#000"),
  bgColor = c("#E41A1C", "#377EB8", "#4DAF4A"),
  borderColor = c("#a90000", "#005288", "#0a7f1c")
)

ui <- fluidPage(
  tags$h2("Custom click event"),
  calendarOutput(outputId = "cal")
)

server <- function(input, output, session) {

  output$cal <- renderCalendar({

    n <- 20

    date_start <- sample(
      seq(from = as.POSIXct(Sys.Date()-14), by = "1 hour", length.out = 24*7*4),
      n, TRUE
    )
    date_end <- date_start + sample(1:25, n, TRUE) * 3600
    schedules <- data.frame(
      id = 1:n,
      calendarId = as.character(sample(1:3, n, TRUE)),
      title = LETTERS[1:n],
      body = paste("Body schedule", letters[1:n]),
      start = format(date_start, format = "\%Y-\%m-\%dT\%H:\%00:\%00"),
      end = format(date_end, format = "\%Y-\%m-\%dT\%H:\%00:\%00"),
      category = sample(c("allday", "time", "task"), n, TRUE),
      stringsAsFactors = FALSE
    )

    calendar(taskView = TRUE, scheduleView = c("time", "allday")) \%>\%
      cal_props(df = calendarProps) \%>\%
      cal_schedules(df = schedules) \%>\%
      cal_events(
        clickSchedule = JS("function(event) {alert(event.schedule.id);}")
      )
  })


}

if (interactive())
  shinyApp(ui, server)
}
